-- EASING --
local path = GAMESTATE:GetCurrentSong():GetSongDir()..'lua/'
local P1xpos, P1ypos, P2xpos, P2ypos
local P1, P2, P1Score, P2Score

loadfile(path..'easing.lua')()

local IsEditMode = function()
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("IsEditMode() check failed to run because there is no Screen yet.")
	  return nil
	end
  
	return (THEME:GetMetric(topscreen:GetName(), "Class") == "ScreenEdit")
end
  
  -- helper function for returning the player AF
  -- works as expected in ScreenGameplay
  -- uses IsEditMode() to find the player AF if we're in EditMode
  --     arguments:  pn is a number like 1 or 2
  --     returns:    the "PlayerP1" or "PlayerP2" ActorFrame in ScreenGameplay
  --                 or, the unnamed equivalent in ScrenEdit
  local GetPlayerAF = function(pn)
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("GetPlayerAF() failed to find the player ActorFrame because there is no Screen yet.")
	  return nil
	end
  
	
	local playerAF = nil
  
	-- Get the player ActorFrame on ScreenGameplay
	-- It's a direct child of the screen and named "PlayerP1" for P1
	-- and "PlayerP2" for P2.
	-- This naming convention is hardcoded in the SM5 engine.
	--
	-- ScreenEdit does not name its player ActorFrame, but we can still find it.
  
	-- find the player ActorFrame in edit mode
	if IsEditMode() then
	  -- loop through all nameless children of topscreen
	  -- and find the one that contains the NoteField
	  -- which is thankfully still named "NoteField"
	  for _,nameless_child in ipairs(topscreen:GetChild("")) do
		if nameless_child:GetChild("NoteField") then
		  playerAF = nameless_child
		  break
		end
	  end
  
	-- find the player ActorFrame in gameplay
	else
	  local player_af = topscreen:GetChild("PlayerP"..pn)
	  if player_af then
		playerAF = player_af
	  end
	end
  
	return playerAF
  end
local linear, inQuad, outQuad, inOutQuad, outInQuad, inCubic, outCubic, inOutCubic, outInCubic, inQuart,outQuart, inOutQuart, outInQuart, inQuint, outQuint, inOutQuint, outInQuint, inSine, outSine, inOutSine,outInSine, inExpo, outExpo, inOutExpo, outInExpo, inCirc, outCirc, inOutCirc, outInCirc, inElastic,outElastic, inOutElastic, outInElastic, inBack, outBack, inOutBack, outInBack, inBounce, outBounce,inOutBounce, outInBounce = ease.linear, ease.inQuad, ease.outQuad, ease.inOutQuad, ease.outInQuad,ease.inCubic, ease.outCubic, ease.inOutCubic, ease.outInCubic, ease.inQuart, ease.outQuart,ease.inOutQuart, ease.outInQuart, ease.inQuint, ease.outQuint, ease.inOutQuint, ease.outInQuint,ease.inSine, ease.outSine, ease.inOutSine, ease.outInSine, ease.inExpo, ease.outExpo, ease.inOutExpo,ease.outInExpo, ease.inCirc, ease.outCirc, ease.inOutCirc, ease.outInCirc, ease.inElastic,ease.outElastic, ease.inOutElastic, ease.outInElastic, ease.inBack, ease.outBack, ease.inOutBack,ease.outInBack, ease.inBounce, ease.outBounce, ease.inOutBounce, ease.outInBounce
local changes = {}

local poptions = {GAMESTATE:GetPlayerState(0):GetPlayerOptions('ModsLevel_Song'), GAMESTATE:GetPlayerState(1):GetPlayerOptions('ModsLevel_Song')}
local isusingreverse = {false, false}
local miniscale = {1,1}
for pn = 1, 2 do
    if poptions[pn] then
        isusingreverse[pn] = poptions[pn]:Reverse() ~= 0
        miniscale[pn] = (200 - poptions[pn]:Mini()) * 0.005
    end
end
local styleName = GAMESTATE:GetCurrentStyle():GetName()
local dMult = (styleName == 'double' and 2 or 1)
local rMult = { isusingreverse[1] and -1 or 1, isusingreverse[2] and -1 or 1 }
local diffName = {}
for pn = 1,2 do
    if GAMESTATE:IsPlayerEnabled(pn-1) then
        diffName[pn] = GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty()
    end
end
local l = 'len'
local e = 'end'


-- Mods to be applied, Number denotes the Mission these mods are applied
local mods1 = {

    {66, '*5 100% Beat, *1 15% dark, *2 5% stealth'},
    {74, '*1 no Stealth'},
    {89.5,'*3 25% flip, *10 -75% invert'},
    {90,'*3 0% flip, *10 0% invert'},
    {90,'*1 15% dark, *1 5% stealth, *1 100% Beat, *1 50% Confusion, *4 50% Tipsy'},
    {90.5,'*3 25% flip, *10 -75% invert'},

    {93,'*3 0% flip, *10 0% invert'},
    {97,'*1 0% dark, *2 5% stealth, *1 100% Beat, *1 no Blink, no Confusion, no Tipsy'},
    {115, '*2 no Stealth'},
    {121, '*5 200% Beat, *2 30% Drunk'},
    {121, '*5 100% Beat, *1 no Drunk'},

    {159, '*5 100% Beat'},

    {66+120, '*5 100% Beat, *1 15% dark, *2 10% stealth'},
    {200, '*1 no Stealth'},

    {89.5+120,'*3 25% flip, *10 -75% invert'},
    {90+120,'*3 0% flip, *10 0% invert'},
    {90+120,'*1 15% dark, *1 5% stealth, *1 100% Beat, *1 50% Confusion, *4 50% Tipsy'},
    {90.5+120,'*3 25% flip, *10 -75% invert'},

    {93+120,'*3 0% flip, *10 0% invert'},
    {97+120,'*1 0% dark, *2 10% stealth, *1 100% Beat, *1 no Blink, no Confusion, no Tipsy'},
    {230, '*1 no Stealth'},

    {66+120+104, '*5 200% Beat, *1 15% dark, *2 5% stealth'},
    {200+104, '*1 no Stealth'},

    {89.5+120+104,'*3 25% flip, *10 -75% invert'},
    {90+120+104,'*3 0% flip, *10 0% invert'},
    {90+120+104,'*1 15% dark, *1 5% stealth, *1 100% Beat, *1 50% Confusion, *4 50% Tipsy'},
    {90.5+120+104,'*3 25% flip, *10 -75% invert'},

    {93+120+104,'*3 0% flip, *10 0% invert'},
    {97+120+104,'*1 0% dark, *2 5% stealth, *1 100% Beat, *1 no Blink, no Confusion, no Tipsy'},
    {101+120+103,'*1 200% Beat, *1 2% Confusion, *4 50% Tipsy'},
	{107+120+103,'*1 300% Beat, *1 no Confusion, *4 no Tipsy, *3 -100% Bumpy'},
	{380,'*1 no Beat, *1 no Confusion, *4 no Tipsy, *3 no Bumpy'},



}

local dialogue1 = {
	{1, function() 
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
				if pn == 1 then
					P1xpos = a:GetX()
					P1ypos = a:GetY()
				else
					P2xpos = a:GetX()
					P2ypos = a:GetY()

				end
			end
		end
	end},
    -- 101, 102 Swap
    -- 103 L
    -- 103.5 R
    -- 104 L
    -- 104.5 R
    -- 105 Spin

	{98,function()
		ups_bobheight:linear(8*(60/174))
		ups_bobheight:x(24)
	end},

    {101-0.3-0.3,function()
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
				a:bounce();
				a:effectperiod(1);
				a:effectclock('bgm');
                a:effectmagnitude(0,-40,0);

                a:decelerate(0.3)
                if pn == 1 then
                    a:x(SCREEN_CENTER_X+160)
                else
                    a:x(SCREEN_CENTER_X-160)
                end
			end
		end
	end},

    {102-0.3,function()
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
                a:decelerate(0.3)
                if pn == 1 then
                    a:x(SCREEN_CENTER_X-160)
                else
                    a:x(SCREEN_CENTER_X+160)
                end
			end
		end
	end},

    {103-0.3,function()
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
                --a:stopeffect()
                a:decelerate(0.2)
                a:rotationz(-30)
			end
		end
	end},
    {103.5-0.3,function()
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
                a:decelerate(0.2)
                a:rotationz(30)
			end
		end
	end},
    {104-0.3,function()
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
                a:decelerate(0.2)
                a:rotationz(-30)
			end
		end
	end},
    {104.5-0.3,function()
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
                a:decelerate(0.2)
                a:rotationz(30)
			end
		end
	end},
    {105-0.3,function()
		for pn=1,2 do
			local a = GetPlayerAF(pn)
			if a then
                a:decelerate(0.5):addrotationy(360)
                a:spring(0.4)
                a:rotationz(0)
                a:stopeffect()
                if pn == 1 then
                    a:decelerate(0.5):xy(P1xpos, P1ypos)
                else
                    a:decelerate(0.5):xy(P2xpos, P2ypos)
                end
			end
		end
	end},


-------------------------
    {101+120-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:bounce();
                a:effectperiod(1);
                a:effectclock('bgm');
                a:effectmagnitude(0,-30,0);

                a:decelerate(0.3)
                if pn == 1 then
                    a:x(SCREEN_CENTER_X+160)
                else
                    a:x(SCREEN_CENTER_X-160)
                end
            end
        end
    end},

    {102+120-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.3)
                if pn == 1 then
                    a:x(SCREEN_CENTER_X-160)
                else
                    a:x(SCREEN_CENTER_X+160)
                end
            end
        end
    end},

    {103+120-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                --a:stopeffect()
                a:decelerate(0.2)
                a:rotationz(-30)
            end
        end
    end},
    {103.5+120-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.2)
                a:rotationz(30)
            end
        end
    end},
    {104+120-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.2)
                a:rotationz(-30)
            end
        end
    end},
    {104.5+120-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.2)
                a:rotationz(30)
            end
        end
    end},
    {105+120-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.5):addrotationy(360)
                a:spring(0.4)
                a:rotationz(0)
                a:stopeffect()
				if pn == 1 then
                    a:decelerate(0.3):xy(P1xpos, P1ypos)
                else
                    a:decelerate(0.3):xy(P2xpos, P2ypos)
                end
            end
        end
    end},

    -------------------------
    {101+120+103-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:bounce();
                a:effectperiod(1);
                a:effectclock('bgm');
                a:effectmagnitude(0,-30,0);

                a:decelerate(0.3)
                if pn == 1 then
                    a:x(SCREEN_CENTER_X+160)
                else
                    a:x(SCREEN_CENTER_X-160)
                end
            end
        end
    end},

    {102+120+103-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.3)
                if pn == 1 then
                    a:x(SCREEN_CENTER_X-160)
                else
                    a:x(SCREEN_CENTER_X+160)
                end
            end
        end
    end},
	{103+120+103,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.5):stopeffect()
            end
        end
    end},
    {105+120+103-0.3,function()
        for pn=1,2 do
            local a = GetPlayerAF(pn)
            if a then
                a:decelerate(0.5):addrotationy(360)
                a:spring(0.4)
                a:rotationz(0)
                a:stopeffect()
				if pn == 1 then
                    a:decelerate(0.3):xy(P1xpos, P1ypos)
                else
                    a:decelerate(0.3):xy(P2xpos, P2ypos)
                end
            end
        end
    end},



    -- {104,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
    --             a:stopeffect()
    --             a:rotationz(30)
	-- 		end
	-- 	end
	-- end},
    -- {104.5,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
	-- 			a:bounce();
	-- 			a:effectclock('bgm');
    --             a:effectmagnitude(0,-60,0);
	-- 			a:effectperiod(0.5);

    --             a:decelerate(0.2)
    --             if pn == 1 then
    --                 a:x(SCREEN_CENTER_X+0)
    --             else
    --                 a:x(SCREEN_CENTER_X+0)
    --             end
	-- 		end
	-- 	end
	-- end},
    -- {104+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
    --             a:decelerate(0.2)
    --             a:rotationz(0)
    --             a:stopeffect()
	-- 		end
	-- 	end
	-- end},
    -- {104.5+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
	-- 			a:bounce();
	-- 			a:effectclock('bgm');
    --             a:effectmagnitude(0,-60,0);
	-- 			a:effectperiod(0.5);

    --             a:decelerate(0.2)
    --             if pn == 1 then
    --                 a:x(SCREEN_CENTER_X-(160/2))
    --             else
    --                 a:x(SCREEN_CENTER_X+(160/2))
    --             end
	-- 		end
	-- 	end
	-- end},
    -- {105+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
    --             a:decelerate(0.2)
    --             if pn == 1 then
    --                 a:x(SCREEN_CENTER_X-(160))
    --             else
    --                 a:x(SCREEN_CENTER_X+(160))
    --             end
	-- 		end
	-- 	end
	-- end},
    -- {105.5+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
    --             a:stopeffect()
	-- 		end
	-- 	end
	-- end},
    -- {106+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
	-- 			a:bounce();
	-- 			a:effectclock('bgm');
    --             a:effectmagnitude(0,0,30);
	-- 			a:effectperiod(2);
	-- 		end
	-- 	end
	-- end},
    -- {108+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
	-- 			a:bounce();
	-- 			a:effectclock('bgm');
    --             a:effectmagnitude(0,-60,0);
	-- 			a:effectperiod(0.5);

                
    --             a:decelerate(0.2)
    --             if pn == 1 then
    --                 a:x(SCREEN_CENTER_X-(160/3))
    --             else
    --                 a:x(SCREEN_CENTER_X+(160/3))
    --             end

	-- 		end
	-- 	end
	-- end},

    -- {108.5+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
                
    --             a:decelerate(0.2)
    --             if pn == 1 then
    --                 a:x(SCREEN_CENTER_X+(160/3))
    --             else
    --                 a:x(SCREEN_CENTER_X-(160/3))
    --             end
	-- 		end
	-- 	end
	-- end},
    -- {109+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
                
    --             a:decelerate(0.2)
    --             if pn == 1 then
    --                 a:x(SCREEN_CENTER_X+(160))
    --             else
    --                 a:x(SCREEN_CENTER_X-(160))
    --             end
	-- 		end
	-- 	end
	-- end},
    -- {109.5+3,function()
	-- 	for pn=1,2 do
	-- 		local a = GetPlayerAF(pn)
	-- 		if a then
    --             a:stopeffect()
	-- 		end
	-- 	end
	-- end},
		
}

-- Messages to be applied, Number denotes the Mission these messages go off for.
local messages1 = {
    {67, "Flowers"},
    {76,'SandSportOn'},
    {80, 'SandSportOff'},
    {82, 'Hours'},
    {93, 'ClockBegone'},
    {120,'SandSportAway'},
	{144, 'Roses'},
    {188, "Flowers"},
    {196,'SandSportOn'},
    {200, 'SandSportOff'},
    {202, 'Hours'},
    {211, 'ClockBegone'},
    {240,'SandSportAway'},

    {291, "Flowers2"},
    {300,'SandSportOn2'},
    {304, 'SandSportOff'},
    {306, 'Hours'},
    {315, 'ClockBegone'},
    {340, 'SandSportOff2'},
    {348,'SandSportAway2'},
    {350, 'Hours'},
    {352,'SandSportOn3'},
	{356, 'SandSportOff2'},
    {380,'SandSportAway'},


}


mods_ease = {

}


me = function(beat,len,str1,str2,mod,t,ease,pn,sus,opt1,opt2)
	table.insert(mods_ease,{beat,len,str1,str2,mod,t,ease,pn,sus,opt1,opt2});
end

m2  = function(beat,msg,p)
	table.insert(dialogue1,{beat,msg,p});
end

function simple_m0d(beat,strength,mult,mod,pn)
	if not strength then strength = 400 end
	if not mult then mult = 1 end
	if not mod then mod = 'drunk' end
	
	local alive = math.max(2*mult*math.abs(strength)/100,0.25)
	
	table.insert(mods,{beat,'*100000 '..strength..' '..mod,pn});
	table.insert(mods,{beat+.1,'*'..((1/mult)*math.abs(strength)/100)..' no '..mod,pn});
end
--alternates a mod back and forth before resetting to 0
--beat,num,div,amt,mod,pn
function mod_wiggle(beat,num,div,amt,mod,pn,first)
	local fluct = 1
	for i=0,(num-1) do
		b = beat+(i/div)
		local m = 1
		if i==0 and not first then m = 0.5 end
		table.insert(mods,{b,'*'..math.abs(m*amt/10)..' '..(amt*fluct)..' '..mod..'',pn});
		fluct = fluct*-1;
	end
	table.insert(mods,{beat+(num/div),'*'..math.abs(amt/20)..' no '..mod..'',pn});
end

function mod_bamBaBamBaBam(beat,amt,mult,mod)
	simple_m0d(beat,amt,mult,mod);
	--simple_m0d(beat+1,amt,mult,mod);
	simple_m0d(beat+1.5,amt,mult,mod);
	--simple_m0d(beat+2.5,amt,mult,mod);
	simple_m0d(beat+3,amt,mult,mod);
end

function mod_baBamBaBam(beat,amt,mult,mod)
	simple_m0d(beat,amt,mult,mod);
	simple_m0d(beat+0.5,amt,mult,mod);
	simple_m0d(beat+1.5,amt,mult,mod);
	simple_m0d(beat+2,amt,mult,mod);
end
function stretchcol(p,c)
    local ct = (type(c) ~= 'table' and {c} or c)
    local pn = p
    local function outfunc(h)

        local plr = GetPlayerAF(pn)
        local nf = plr:GetChild('NoteField')
        for i,v in ipairs(ct) do
            local ca = nf:GetColumnActors()[v+1]
            ca:GetPosHandler():SetSplineMode('NoteColumnSplineMode_Offset')
            ca:GetPosHandler():SetBeatsPerT(6)
            local spl = ca:GetPosHandler():GetSpline()
            spl:SetSize(2)
            spl:SetPoint(1, {0, 5.4*h*rMult[pn], 0})
            spl:SetPoint(2, {0, -5.4*h*rMult[pn], 0.01*h*rMult[pn]})
            spl:Solve()
        end
    end
    return outfunc
end

function bouncecol(p,b,c,h)
    local ct = (type(c) ~= 'table' and {c} or c)
    local pn = p
    me(b,0.5,0,h,stretchcol(p,c),l,outCubic)
    me(b+0.5,3,h,0,stretchcol(p,c),l,inCubic)
    m2(b+1,function()
        local plr = GetPlayerAF(pn)
        local nf = plr:GetChild('NoteField')
        for i,v in ipairs(ct) do
            local ca = nf:GetColumnActors()[v+1]
            ca:GetPosHandler():SetSplineMode('NoteColumnSplineMode_Disabled')
            ca:GetPosHandler():SetBeatsPerT(6)
            local spl = ca:GetPosHandler():GetSpline()
            spl:SetSize(2)
            spl:SetPoint(1, {0, 0, 0})
            spl:SetPoint(2, {0, 0, 0})
            spl:Solve()
        end
    end)
end


for pn = 1,2 do
    if diffName[pn] then
        local bouncyboys
        if dMult == 1 then -- we're on single
                bouncyboys = { 2,1,2,1,2,1,2 }
        else -- we're on double
            if false then -- check for different step difficulties here
            else
                bouncyboys = { 2,4,6,3,6,5,6 }
            end
        end
        if bouncyboys then -- sanity check
            neg = 1
            dabeat = 17
            for num = 0,8 do
                neg = -1 * neg
                bouncecol(pn,dabeat,(num+4) % 4,20*neg)
                dabeat = dabeat + 4
            end
            bouncecol(pn,53,2,-20)
            
            bouncecol(pn,124.5,2,-20)
            bouncecol(pn,124.5,3,-20)
            bouncecol(pn,132.5,0,20)
            bouncecol(pn,132.5,2,-15)
            --bouncecol(pn,182.5,3,30)

            bouncecol(pn,244.5,0,10)
            bouncecol(pn,244.5,1,10)

            bouncecol(pn,252.5,1,-10)
            bouncecol(pn,252.5,3,10)

            bouncecol(pn,260.5,2,-15)
            bouncecol(pn,260.5,3,15)

            bouncecol(pn,268.5,0,-10)
            bouncecol(pn,268.5,3,-10)

			bouncecol(pn,355.5,2,10)
            bouncecol(pn,355.5,3,-10)

			bouncecol(pn,363.5,2,15)
            bouncecol(pn,363.5,3,-20)

			bouncecol(pn,371.5,0,-10)
            bouncecol(pn,371.5,2,-10)

        end
    end
end

local difficulty, sTable
local currentSong = GAMESTATE:GetCurrentSong()
local path = currentSong:GetSongDir()

--[[

	Some of the code below here is part of the "Preliminary Check"
	We want to just check on a couple things to ensure a safe flight

	1. Version Warning - Stepmania Versions above 5.1 seem to interpet the mods differently
	2. Edit Chart - If the player is in Edit Mode or is on the Edit Chart, the mods do not play
	3. Mixmatch Choices - If one player is on Edit and the other is not, then both get set to Edit
		This is to ensure that no one is able to get a score on the modded charts by playing/reading an
		unmodded chart

]] --




local version = tonumber(string.match(ProductID(), '%d+%.?%d*$')) or 5.0;
if version > 5.1 then
    SCREENMAN:SystemMessage('Sorry, this song was made for SM 5.1');
end

local WideScale = function(AR4_3, AR16_9)
    -- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
    local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
    return scale(w, 640, 854, AR4_3, AR16_9)
end




local function setChanges()
    changes = dialogue1
    messages = messages1
    mods = mods1
    bigImages = true
    -- sort the messages by beat number (first index) just in case
    table.sort(messages, function(m1, m2) return m1[1] < m2[1] end)
    table.sort(changes, function(m1, m2) return m1[1] < m2[1] end)

end



local function Handler_mod_internal(str, pn) -- Applies Players options to not be disabled-
    local ps = GAMESTATE:GetPlayerState(pn)
    local pmods = ps:GetPlayerOptionsString('ModsLevel_Song')
    ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
    -- GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function Handler_mod(str) -- Looks for many players are on the screen
    for i = 1, 2 do Handler_mod_internal(str, 'PlayerNumber_P' .. i) end
end

local function Handler_init() -- Useful for command shorcuts
    if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
        P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
    end
    if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
        P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')

    end
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score') then
        P1Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P1Score')
    end
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score') then
        P2Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P2Score')
    end

    fgcurcommand = 0;
    wndr_skewx = 0.3;
    checked = false;

    curmod = 1;
    -- {beat,'mod'},
    mods = {}
    -- SCREAMING GUMBALL / timed message broadcaster
    curmessage = 1;
    -- {beat,message,ignoreIfAhead}
    messages = {}

    setChanges()

end
local counter = 1

local function Handler_update() -- Updates the command to look for the players at the start of the song.

    if GAMESTATE:GetSongBeat() >= 0.1 and not checked then

        screen = SCREENMAN:GetTopScreen()

        checked = true;

    end
    if changes[counter] and GAMESTATE:GetSongBeat() >= changes[counter][1] then
        changes[counter][2]()
        counter = counter + 1
    end
    local beat = GAMESTATE:GetSongBeat()

				--------------------------------------------------------------------------------------
    for i,v in pairs(mods_ease) do
        if v and table.getn(v) > 6 and v[1] and v[2] and v[3] and v[4] and v[5] and v[6] and v[7] then
            if beat >=v[1] then
                if (v[6] == 'len' and beat <=v[1]+v[2]) or (v[6] == 'end' and beat <=v[2]) then
                    local duration = v[2]
                    if v[6] == 'end' then duration = v[2] - v[1] end
                    local curtime = beat - v[1]
                    local diff = v[4] - v[3]
                    local startstrength = v[3]
                    local curve = v[7]
                    local mod = v[5]
                    
                    local strength = curve(curtime, startstrength, diff, duration, v[10], v[11]) --extra parameters for back and elastic eases :eyes:
                    
                    if type(v[5]) == 'function' then
                        v[5](strength)
                    else
                        local modstr = v[5] == 'xmod' and strength..'x' or (v[5] == 'cmod' and 'C'..strength or strength..' '..v[5])
                        mod_do('*10000 '..modstr,v[8])
                    end
                    
                elseif (v[9] and ((v[6] == 'len' and beat <=v[1]+v[2]+v[9]) or (v[6] == 'end' and beat <=v[9]))) then
                
                    local strength = v[4]
                    
                    if type(v[5]) == 'function' then
                        v[5](strength)
                    else
                        local modstr = v[5] == 'xmod' and strength..'x' or (v[5] == 'cmod' and 'C'..strength or strength..' '..v[5])
                        mod_do('*10000 '..modstr,v[8])
                    end
                end
            end
        else
            SCREENMAN:SystemMessage('Bad mod in beat-based ease table (line '..i..')')
        end
    end
    -- SM(beat)
    -- Collect all the mods that will be applied in this frame into one string.
    -- Mod tweening doesn't work correctly if the mods are in seperate commands.
    local mods_this_frame = {}
    local function add_mod(mod_str)
        mods_this_frame[#mods_this_frame + 1] = mod_str
    end
    local function execute_mods()
        if #mods_this_frame <= 0 then return end
        local total_mod_str = ""
        for i, ms in ipairs(mods_this_frame) do
            if #total_mod_str > 0 then
                total_mod_str = total_mod_str .. ", "
            end
            total_mod_str = total_mod_str .. ms
        end
        Handler_mod(total_mod_str)
    end

    while curmod <= #mods and GAMESTATE:GetSongBeat() >= mods[curmod][1] do
        add_mod(mods[curmod][2])
        curmod = curmod + 1
    end

    execute_mods()

    while curmessage <= #messages and GAMESTATE:GetSongBeat() >=
        messages[curmessage][1] do
        if messages[curmessage][3] and GAMESTATE:GetSongBeat() >=
            messages[curmessage][1] + 5 then
            curmessage = curmessage + 1;
        else
            MESSAGEMAN:Broadcast(messages[curmessage][2])
            curmessage = curmessage + 1;
        end
    end
end

local last_score_x = 0
local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()
local multitap_parent = Def.ActorFrame {

    OnCommand = function(self)
        Handler_init()
        self:SetUpdateFunction(Handler_update)

        -- ---------------------
        -- hide ScreenGameplay's "in" layer,
        -- which typically has a text overlay for
        -- "EVENT MODE" or "STAGE 1" or similar
        local screen = SCREENMAN:GetTopScreen()
        -- ---------------------
    end,
    Def.Quad {
        Name = "I may be sleeping, but I preserve the world.",
        InitCommand = cmd(visible, false),
        OnCommand = cmd(sleep, 1000)
    },
    LoadActor("Carrot.mp4")..{				
		InitCommand= function(self)
			self:visible(false)
			if (not IsEditMode()) then
				self:visible(true)
				local src_w = self:GetTexture():GetSourceWidth()
				self:Center():zoom(_screen.w/WideScale(src_w*0.75,src_w))
				self:diffusealpha(1):rate(musicrate+0.25)
				--Zoom the background video based on the width of the original mp4
				-- so that it fits perfectly in 16:9 and crop the sides in 4:3 borrowed' from quietly-turning's watermelon
			end
		end,
	},
    Def.Sprite{
        Frames = {												
          {Frame=0,Delay=0.128709/4},
          {Frame=1,Delay=0.128709/4},
          {Frame=2,Delay=0.128709/4},
          {Frame=3,Delay=0.128709/4},
          {Frame=4,Delay=0.128709/4},
          {Frame=5,Delay=0.128709/4},
          {Frame=6,Delay=0.128709/4},
          {Frame=7,Delay=0.128709/4},
          {Frame=8,Delay=0.128709/4},
          {Frame=9,Delay=0.128709/4},
          {Frame=10,Delay=0.128709/4},
          {Frame=11,Delay=0.128709/4},
          {Frame=12,Delay=0.128709/4},
          {Frame=13,Delay=0.128709/4},
          {Frame=14,Delay=0.128709/4},
          {Frame=15,Delay=0.128709/4},
          {Frame=16,Delay=0.128709/4},
          {Frame=17,Delay=0.128709/4},
          {Frame=18,Delay=0.128709/4},
          {Frame=19,Delay=0.128709/4},
          {Frame=20,Delay=0.128709/4},
          {Frame=21,Delay=0.128709/4},
          {Frame=22,Delay=0.128709/4},
          {Frame=23,Delay=0.128709/4},

        };
            Texture = 'WhirlClock 4x6.png';
            InitCommand = function(self) 
              sprite_bear = self; 
              self:visible(false):Center():zoom(1.8):diffusealpha(0)
            end,
            HoursMessageCommand=function(self)
               self:visible(true):animate(true):linear(5):diffusealpha(0.5)
            end,
            ClockBegoneMessageCommand=function(self)
                self:linear(5):diffusealpha(0)
            end
        },
    Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P1Score then
				self:SetTarget(P1Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P2Score  then
				self:SetTarget(P2Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P1  then
				self:SetTarget(P1)
			end
		end
	},

	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P2 then
				self:SetTarget(P2)
			end
		end
	},
    LoadActor("Carrot.mp4")..{
		InitCommand= function(self)
			if IsEditMode() then 
				self:animate(false):loop(false):rate(musicrate+0.25):visible(false)
			else
				video = self
			end
	
		end,
		OnCommand = function(self)
			if IsEditMode() then 
				self:visible(false)
			else
				local src_w = self:GetTexture():GetSourceWidth()
				self:Center():zoom(_screen.w/WideScale(src_w*0.75,src_w)):diffusealpha(0.2):rate(musicrate+0.25)
			end
			-- Zoom the background video based on the width of the original mp4
			-- so that it fits perfectly in 16:9 and crop the sides in 4:3 borrowed' from quietly-turning's watermelon
		end
	},


}



-------------------------------------------------------------------------------
--
--		Multitap Factory & Assistance
--		
--		Author: 	Telperion
--		Date: 		2019-11-29
--		Version:	1.1.2 (see notes from quietly-turning, crash cringle)
--		Target:		SM5.0.12+/ITGMania
--
-------------------------------------------------------------------------------
-- 
--		So, like...it's been three years since UKSRT8 and TaroNuke's
--		"Hardware Bullshit Tournament", the event where a prototype of a dance
--		pad with fine-grained pressure response got an exhibition with a whole
--		set of files featuring new (to 4-panel) chart mechanics. It really was
--		a blast! and I've wished for a while now that there would eventually be
--		some way to play the whole thing at home.
--
--		During a post-UKSRTX hangout, Taro lugged the platform out so newcomers
--		who hadn't been around for UKSRT8 could give the HBT files a shot. 
--		While watching, something clicked in my brain: the pieces of a few 
--		half-finished SM5 mods files I had lying around could be assembled,
--		with a little extra work, into the HBT multitap note type.
--		[https://www.youtube.com/watch?v=OQiZJ38fDJM&t=1m04s]
--
--		I got to sweep out some very dark corners of StepMania 5 with this one:
--		*	You can just *make* fakes and explosions, if you hook them up right
--		*	Really glad non-beat-subtracting offset zoom splines work the way
--			I expected, because I couldn't think of any sensible other options
--		*	Parameter ordering in ArrowEffects:Get<>() calls is spicy
--				(which will eventually require an update to this code, because
--				I opened my big mouth :P)
--		*	Sad about lack of access to the FOV and vanishing point of an actor
--				(straight up translated portions of the C++ source for that)
--		*	Mysterious version-dependent radian poltergeist?? hello??????
--		*	I didn't actually know propagatecommand existed until I wrote a 
--			(poorly-covering) function to do the same thing with reflection
--		*	Kinda wish there was a generic way to retrieve the color scheme of
--			a rhythm noteskin (e.g., solo vs. note)
--		*	Playfields aren't vertically centered in the screen and this is 
--			*theme-dependent* and although I understand why that might be
--			useful I sure as hell am allowed to complain about it
--
--		But the upshot is:
--		*	You can write your own multitap files!
--			1.	Copy this FG animation (multitap\*) into your song directory
--			2.	Copy the #FGCHANGES: line into your .ssc file
--			3.	Replace multitap_data.lua to suit your chart
--				(eventually I will also provide autogeneration code for this
--				based on interpreting the corresponding double slot)
--			4.	Increase brain wrinkliness
--			5a.	Have a tappy slappy time
--			5b.	Recoil in horror from what you have brought into existence
--		*	Multitaps should be compatible with most common SM5 noteskins
--		*	Multitaps will act like regular taps under all* mods
--		*	Multitap-enabled files will work on most cabs running
--			SM5.0.12+ and Simply Love
--
--		TODO:
--		*	Soften the hardcoding of 4-panel mode
--		*	Soften use of 45-degree FOV for spoofing perspective mods (just in
--			case other FG changes want to mess with that)
--		*	Haven't figured out how to implement arrow glow yet (for use
--			during stealth/hidden/sudden sections)
--		*	Some themes (Lambda in particular) throw off my Mini calculations
--		*	Track down the mysterious version-dependent radian poltergeist
--		*	Multitaps under Cmod don't move smoothly. For now I'm pretending
--			this is a feature :)
--		*	nITG compatibility...
--
--		TRICKY:
--		*	This implementation of multitaps locks down zoom splines - no 
--			additional FG animations should attempt to use them without
--			accounting for the multitap regions
--		*	Anything in the multitap regions will be hidden, but only taps get
--			re-presented to the player. Lifts, mines, and fakes will be
--			invisible (but still hittable...)
--
-------------------------------------------------------------------------------
--
-- note from quietly-turning:
-- thanks for this framework, Telperion!  you certainly know your stuff.  :^)
-- 
-- I've slightly modified this file!  Here's what's new in version 1.1.1:
--
--		*	allow different difficulties to have and not-have multitap data
--			and to be played simultaneously without throwing Lua errors
--		*	play multitap data in SM5's editor
--			I tested in 5.1-beta but 5.0.12 should work fine, too.
--
-- Helpful notes:
--		*	this framework currently expects all available columns to have
--			and use multitap data!  you'll need to include multitap data for
--			for all 4 columns in your multitap_data.lua file, and write your
--			stepchart accordingly.
--
--			I don't understand this Lua framework and SM5's NCSplineHandler
--			well enough to know how to change this.
--
-------------------------------------------------------------------------------
--
-- note from crash cringle:
-- I've modified this file to work with ITGMania 
-- This is probably worth noting, but ITGMania is sm version 0.5.1 technically, which breaks 
-- any mod chart that checked if the game version was 5.x or higher.



--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
--
-- Generate multitap_data.lua using Telperion's Python chart utilities.
-- MultitapsWorkflow(r'C:\path\to\simfile.sm')
--
-- Version matching performed here.
--
--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
multitaps = {}
multitap_version = {1, 1}

-- Load multitap data into workspace
local whereTheFlipAmI = GAMESTATE:GetCurrentSong():GetSongDir()
dofile(whereTheFlipAmI .. "lua/multitap_data.lua")

-- Compare version of multitap data and multitap parser.
local version_mismatch = function(mv_data, mv_parser)
	SCREENMAN:SystemMessage("### Multitap version mismatch: data @ "..mv_data[1].."."..mv_data[2]..", parser @ "..mv_parser[1].."."..mv_parser[2])
end
local version_record = function(mv_data, mv_parser)
	Trace("### Multitap versions: data @ "..mv_data[1].."."..mv_data[2]..", parser @ "..mv_parser[1].."."..mv_parser[2])
end

if multitaps["_version"] then
	version_record(multitaps["_version"], multitap_version)
	-- Data version major can't be greater than parser version major
	if multitaps["_version"][1] > multitap_version[1] then
		version_mismatch(multitaps["_version"], multitap_version)
		return Def.ActorFrame{}
	end
	-- Data version minor can't be greater than parser version minor
	if (multitaps["_version"][1] == multitap_version[1]) and 
		(multitaps["_version"][2] > multitap_version[2]) then
		version_mismatch(multitaps["_version"], multitap_version)
		return Def.ActorFrame{}
	end
else
	SCREENMAN:SystemMessage("### Found unversioned multitap data")
end
-- -------------------------------------------------------------------------------


--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
--
-- 		holh fucf?
--
--
-- 													HOLKY FUCY???
--
--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--

local IsStepMania = function()
	if type(ProductFamily) ~= "function" then return false end
	return ProductFamily() == "StepMania"
  end
  
  local IsITGmania = function()
	if type(ProductFamily) ~= "function" then return false end
	return ProductFamily() == "ITGmania"
  end
  
  
  -- transform a StepMania version string ("5.0.12") into a table of numbers { 5, 0, 12 }
  local getProductVersion = function()
	if type(ProductVersion) ~= "function" then return {} end
  
	-- get the version string, e.g. "5.0.11" or "5.1.0" or "5.2-git-96f9771" or etc.
	local version = ProductVersion()
	if type(version) ~= "string" then return {} end
  
	-- remove the build suffix from the version string
	-- debug build are suffixed with "-git-$something" or "-UNKNOWN" if the
	-- git hash is not available for some reason
	version = version:gsub("-.*", "")
  
	-- parse the version string into a table
	local v = {}
	for i in version:gmatch("[^%.]+") do
	  table.insert(v, tonumber(i))
	end
  
	return v
  end
  
  local version_numbers = getProductVersion()
  
  local sm_version = ProductVersion()
  local MYSTERIOUS_VERSION_DEPENDENT_RADIAN_POLTERGEIST = (-180 / math.pi)
  
  -- handle [StepMania 5.1.0, ITGMania 0.5.1] differently than StepMania 5.0.12  D:
  if (IsStepMania() and (version_numbers[1]==5 and version_numbers[2]==1) or IsITGmania()) then
	MYSTERIOUS_VERSION_DEPENDENT_RADIAN_POLTERGEIST = (-180 / math.pi)
  end
  
--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
--
-- Multitap generation code begins here
--
--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--


-- Controls for tweaking visual behavior of multitaps
local multitap_error = false 					-- How is multitap parsing going?
local multitap_previsible = 14					-- Make the multitaps visible this many beats in advance of the first hit
local multitap_basebounce = 3			-- Multiplier for initial bounce velocity (1x matches inbound speed)
local multitap_elasticity = 1			-- Subsequent bounces get their rebound speed multiplied by this
local multitap_squishy = 0.1				-- Cartoonishly squish the arrow when traveling slowly and expand when fast.
local multitap_splines_calc = {false, false}	-- Spline Times EX should have stayed in pop'n 8. and that's the tea

-- Gotta know how many of these to make.
local multitap_max = 0
for _,mt_list in pairs(multitaps) do
	if multitap_max < #mt_list then
		multitap_max = #mt_list
	end
end

-- Initialize the multitap actor list.
-- 
-- 	Player number (1 or 2)
--		Multitap index
--			{frame, arrow, count}
local multitap_actors = {
	{},
	{}
}
for pn = 1,2 do
	for i = 1,multitap_max do
		multitap_actors[pn][i] = {}
	end
end
local multitap_explosions = {
	{},
	{}
}
local multitap_fields = {}

-- Slot and noteskin selection for each player.
local multitap_chart_sel = {
	"Hard",
	"Hard"
}
local noteskin_names = {
	"shadow",
	"shadow"
}

-- Precalculate a table of quantization colors by beat fraction.
-- Used to select a texture offset in the noteskin asset for the tap arrow.
local qtzn_lookup = {}
for _,qtzn in ipairs({48, 24, 16, 12, 8, 6, 4, 3, 2, 1}) do
	for i = 0,48,(48/qtzn) do
		qtzn_lookup[i] = qtzn
	end
end

local qtzn_tex = {}
qtzn_tex[ 0] = 0
qtzn_tex[ 1] = 0
qtzn_tex[ 2] = 1
qtzn_tex[ 3] = 2
qtzn_tex[ 4] = 3
qtzn_tex[ 6] = 4
qtzn_tex[ 8] = 5
qtzn_tex[12] = 6
qtzn_tex[16] = 7
qtzn_tex[24] = 7
qtzn_tex[48] = 7


-- I don't think it's reasonable within the UPS5 submission timeframe to
-- dynamically pull/calculate the actual *color* of each quantization for
-- an arbitrary noteskin, so I'm precalculating some options based on the
-- Cabby noteskin pack.
local qtzn_color_tables = {
	vivid = {					-- whole texture I'm fucking busy only get few color
		{"ffffff", "cccccc"},	-- 4ths
		{"ffffff", "cccccc"},	-- 8ths
		{"ffffff", "cccccc"},	-- 12ths
		{"ffffff", "cccccc"},	-- 16ths
		{"ffffff", "cccccc"},	-- 24ths
		{"ffffff", "cccccc"},	-- 32nds
		{"ffffff", "cccccc"},	-- 64ths
		{"ffffff", "cccccc"},	-- 192nds
	},
	shadow = {					-- best colorblindness acuity in the noteskins sharing the ITG palette
		{"ff6100", "ff0000"},	-- 4ths
		{"00a2ff", "00f0ff"},	-- 8ths
		{"fa81d1", "7a15fe"},	-- 12ths
		{"e2f90f", "09a357"},	-- 16ths
		{"fa81d1", "7a15fe"},	-- 24ths
		{"f1db03", "e67b02"},	-- 32nds
		{"33fc7b", "04b8b6"},	-- 64ths
		{"33fc7b", "04b8b6"},	-- 192nds
	},
	color = {					-- the most like unto the true DDR Note noteskin
		{"ffc5c5", "ff0000"},	-- 4ths
		{"0000ff", "c5c5ff"},	-- 8ths
		{"00ff00", "c5ffc5"},	-- 12ths
		{"fff617", "646001"},	-- 16ths
		{"00ff00", "c5ffc5"},	-- 24ths
		{"00ff00", "c5ffc5"},	-- 32nds
		{"00ff00", "c5ffc5"},	-- 64ths
		{"00ff00", "c5ffc5"},	-- 192nds
	},
	note = {					-- this is what the DDR Note noteskin should have been
		{"ff7c7c", "ff2121"},	-- 4ths
		{"7e86f4", "2432ec"},	-- 8ths
		{"be77fb", "9018f8"},	-- 12ths
		{"faff73", "f7ff11"},	-- 16ths
		{"f383bf", "eb2c93"},	-- 24ths
		{"ff966d", "ff4d06"},	-- 32nds
		{"90e3ff", "43d0ff"},	-- 64ths
		{"85ff7c", "30ff20"},	-- 192nds
	},
	rainbow = {					-- some time...you just haven`t care
		{"ff6100", "ff0000"},	-- 4ths
		{"00a2ff", "00f0ff"},	-- 8ths
		{"fa81d1", "7a15fe"},	-- 12ths
		{"fa81d1", "7a15fe"},	-- 16ths
		{"fa81d1", "7a15fe"},	-- 24ths
		{"fa81d1", "7a15fe"},	-- 32nds
		{"fa81d1", "7a15fe"},	-- 64ths
		{"fa81d1", "7a15fe"},	-- 192nds
	},
	horseshoe = {				-- I think it's very unprofessional of the official Trot 100 News account to try and cancel an artist.
		{"dfa9db", "a96fba"},	-- 4ths
		{"faba61", "d49234"},	-- 8ths
		{"98d3f1", "2c78b6"},	-- 12ths
		{"fe96b9", "b7366e"},	-- 16ths
		{"b6b3d5", "6947bf"},	-- 24ths
		{"f0e56e", "eae6bf"},	-- 32nds
		{"8b7bff", "503497"},	-- 64ths
		{"ebe6ad", "edb032"},	-- 192nds
	},
}
-- Anything not explicitly assigned here will pick up the "vivid" behavior (no color distinction).
qtzn_color_tables["ascii"]							= qtzn_color_tables["note"]
qtzn_color_tables["cel"]							= qtzn_color_tables["shadow"]
--qtzn_color_tables["color"]
qtzn_color_tables["cyber"]							= qtzn_color_tables["shadow"]
qtzn_color_tables["default"]						= qtzn_color_tables["note"]
qtzn_color_tables["delta"]							= qtzn_color_tables["shadow"]
qtzn_color_tables["enchantment"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["easyv2"]							= qtzn_color_tables["note"]
qtzn_color_tables["exactv2"]						= qtzn_color_tables["note"]
qtzn_color_tables["excel"]							= qtzn_color_tables["shadow"]
qtzn_color_tables["excelx"]							= qtzn_color_tables["shadow"]
qtzn_color_tables["horsehorsenote"]					= qtzn_color_tables["note"]
qtzn_color_tables["horsegroove"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["horsenote"]						= qtzn_color_tables["note"]
qtzn_color_tables["horsemaniax"]					= qtzn_color_tables["shadow"]
--qtzn_color_tables["horseshoe"]
qtzn_color_tables["lambda"]							= qtzn_color_tables["note"]
qtzn_color_tables["metal"]							= qtzn_color_tables["shadow"]
qtzn_color_tables["midi-note"]						= qtzn_color_tables["note"]
qtzn_color_tables["midi-note-3d"]					= qtzn_color_tables["note"]
qtzn_color_tables["midi-solo"]						= qtzn_color_tables["rainbow"]
--qtzn_color_tables["note"]
qtzn_color_tables["onlyonecouples"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["peter-ddrlike"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["peterddrnote"]					= qtzn_color_tables["color"]
qtzn_color_tables["peterddrrainbow"]				= qtzn_color_tables["rainbow"]
qtzn_color_tables["peters-ddrlike"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["peters-ddr-note"]				= qtzn_color_tables["color"]
qtzn_color_tables["peters-ddr-rainbow"]				= qtzn_color_tables["rainbow"]
qtzn_color_tables["peters-scalable-cel"]			= qtzn_color_tables["shadow"]
qtzn_color_tables["peters-scalable-vibrantmetal"]	= qtzn_color_tables["shadow"]
--qtzn_color_tables["rainbow"]
qtzn_color_tables["retro"]							= qtzn_color_tables["note"]
qtzn_color_tables["retrobar"]						= qtzn_color_tables["note"]
--qtzn_color_tables["shadow"]
qtzn_color_tables["scalable"]						= qtzn_color_tables["shadow"]
qtzn_color_tables["scalable-cel"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["scalable-metal"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["solo"]							= qtzn_color_tables["rainbow"]
qtzn_color_tables["spotlight"]						= qtzn_color_tables["shadow"]
qtzn_color_tables["toonprints"]						= qtzn_color_tables["horseshoe"]
qtzn_color_tables["trax"]							= qtzn_color_tables["note"]
qtzn_color_tables["vel"]							= qtzn_color_tables["shadow"]
qtzn_color_tables["vibrant-cel"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["vibrant-metal"]					= qtzn_color_tables["shadow"]
qtzn_color_tables["vintage"]						= qtzn_color_tables["shadow"]
--qtzn_color_tables["vivid"]

local _BB = function(b)
	-- Measure beats in increments of 192nds (= 1/48 of quarter notes).
	return math.floor(b*48 + 0.5)
end

local calc_qtzn = function(b)
	-- What quantization is this beat number?
	-- e.g., quarter = 1, 16th = 4, 24th = 6, etc.

	-- Graceful fallback for no-tap case.
	if not b then
		return 0
	end

	-- Each quarter can be divided into 48 steps.
	-- Get the nearest proper step.
	local d48 = math.floor(b*48 + 0.5) - math.floor(b)*48

	-- Decide where it falls.
	return qtzn_lookup[d48]
end

local parabolator = function(b, t, elastic)
	-- b = beat length of this multitap iteration
	-- t = time in beats since the start of this multitap iteration
	-- elastic = scaling of arrowpath position (1 = perfect bounce from approach speed, 0 = dead stop)
	-- returns distance back up the arrow path to travel
	--
	-- f(t) = v/b * t * (b - t), where v = approach speed
	-- we can get around needing to know the pixelar speed of the arrow by calculating distance
	-- in terms of beats traveled @ whatever the reading speed is.
	-- therefore the approach is always 1 beat/beat >:)
	if not elastic then
		elastic = 1
	end
	return elastic * t * (b-t) / b
end

local parabolator_dt = function(b, t, elastic)
	-- b = beat length of this multitap iteration
	-- t = time in beats since the start of this multitap iteration
	-- elastic = scaling of arrowpath position (1 = perfect bounce from approach speed, 0 = dead stop)
	-- returns distance back up the arrow path to travel
	--
	-- f(t) = v/b * t * (b - t), where v = approach speed
	-- we can get around needing to know the pixelar speed of the arrow by calculating distance
	-- in terms of beats traveled @ whatever the reading speed is.
	-- therefore the approach is always 1 beat/beat >:)
	if not elastic then
		elastic = 1
	end
	return elastic * (b - 2*t) / b
end
local apple = {false, false}
local calc_multitap_phase = function(mt_desc, b)
	-- mt_desc = multitap descriptor with the following elements:
	--		lane: which lane the tap is in (unimportant here)
	--		taps: tap beat times included in this multitap
	-- b = current beat
	-- returns a table with the following elements:
	--		rem: # of hits left (the multitap should show a number if it's more than 1)
	--		pos: position in beats before receptors
	--		qtc: quantization of currently approaching note
	--		qtn: quantization of next note in the multitap (used to color the number)
	--		dif: diffuse arrow from 0 (dark) to 1 (full brightness)
	--		vis: currently visible (true/false)
	local ret = {
		rem = 0,
		pos = 0,
		sqh = 0,
		qtc = 0,
		qtn = 0,
		dif = 0,
		vis = false
	}

	if not mt_desc then
		Trace("No multitap descriptor??")
		multitap_error = true
		return ret
	end
	local mt_taps = mt_desc["taps"]
	if not mt_taps then
		Trace("No tap description in multitap??")
		multitap_error = true
		return ret
	end

	if #mt_taps == 0 then
		Trace("An empty multitap is fine I guess")
		return ret
	end		

	if b > mt_taps[#mt_taps] then
		-- Already past the last tap! But don't yell about it. Loudmouth
		return ret
	end

	-- Basic case for when we're earlier than the first tap.
	ret.rem = #mt_taps
	ret.pos = mt_taps[1] - b
	ret.sqh = 0
	ret.qtc = calc_qtzn(mt_taps[1])
	ret.qtn = calc_qtzn(mt_taps[2])
	ret.dif = 0
	ret.vis = (ret.pos < multitap_previsible)

	-- Start with the elasticity at the baseline,
	-- or if the "peak" parameter is set for this multitap, substitute it directly.
	local el = (mt_desc["peak"] and mt_taps[2]) and (mt_desc["peak"] / (mt_taps[2] - mt_taps[1])) or multitap_basebounce
    if apple[1] or apple[2] then
		el2 = el *0.3
	else
		el2 = 0

	end

	for i = 1,#mt_taps do
		-- Any bounce cases happen here.
		if b <= mt_taps[i] then
			break
		end

		-- Compound the elasticity, or continue to hold the peak constant.
		el = mt_desc["peak"] and (mt_desc["peak"] / (mt_taps[i+1] - mt_taps[i])) or (el * multitap_elasticity)

		-- We're assured to have an i+1 element here because
		-- we've already jumped out when b > mt_taps[#mt_taps].
		ret.rem = #mt_taps - i
		ret.pos = parabolator(mt_taps[i+1] - mt_taps[i], b - mt_taps[i], el2)
		ret.sqh = multitap_squishy*(math.abs(parabolator_dt(mt_taps[i+1] - mt_taps[i], b - mt_taps[i], el)) - 0.5)
		ret.qtc = calc_qtzn(mt_taps[i+1])
		ret.qtn = calc_qtzn(mt_taps[i+2])
		ret.dif = i / (#mt_taps-1)
		ret.vis = true
	end

	return ret
end

-- Provide a custom explosion callback message for each player.
-- The false explosions give better visual reinforcement for multitap hits.
for i=1,2 do
	local pn = i
	_G["multitap_note_callback_P"..i] = function(lane, tns, is_bright)
		
		-- -----------------------------------------------------
		-- if we're in EditMode and doing anything other than watching playback
		-- don't propagate any commands to multitap_explosions
		--     the multitap_explosions ActorFrame will be "stale"
		--     "referenced ActorFrame was used but no longer exists"
		-- only propagate if we're watching playback       -quietly
		-- -----------------------------------------------------
		if IsEditMode() then
			local topscreen = SCREENMAN:GetTopScreen()
			if not (topscreen and topscreen:GetEditState() == 'EditState_Playing') then
				return
			end
		end
		-- -----------------------------------------------------			
		
		if multitap_explosions[pn][lane] then
			--Trace("??? do explosion pls")
			multitap_explosions[pn][lane]:propagatecommand("Judgment")
			multitap_explosions[pn][lane]:propagatecommand("Dim")
			multitap_explosions[pn][lane]:propagatecommand(string.sub(tns, 14))

		end
	end
end

local calc_zoom_splines = function(mt_table, pn)
	-- Use non-beat-subtracting offset zoom splines to hide real taps.
	--
	-- Wait, what?
	--
	-- Non-beat-subtracting
	--		Think of the spline as traveling along with the arrows, rather than
	--		staying fixed to the player's viewable section of the chart.
	-- Offset
	--		Instead of overwriting the original arrow path, the spline is
	--		applied as a change to that path. Here we use zooms of 0 or -1,
	--		representing (1 + 0)x = visible or (1 + -1)x = invisible.
	-- Zoom spline
	--		Set a mathematical function that describes the scaling of an arrow
	--		landing on any given beat.

	if not mt_table then return end

	-- Calculate length of spline needed.
	local splSize = {}
	for mti,mt_desc in ipairs(mt_table) do
		if not splSize[mt_desc.lane] then
			splSize[mt_desc.lane] = 0
		end

		if #mt_desc.taps > 0 then
			if mt_desc.taps[#mt_desc.taps] > splSize[mt_desc.lane] then
				splSize[mt_desc.lane] = mt_desc.taps[#mt_desc.taps]
			end
		end
	end

	-- Convert to 192nds count.
	for i,v in ipairs(splSize) do
		splSize[i] = _BB(v) + 2
	end
	
	

	-- Apply the spline points.
	local pp = GetPlayerAF(pn)
	local nf = pp:GetChild('NoteField')
	local ncr_table = nf:GetColumnActors()

	-- Apply the false explosion callback.
	nf:SetDidTapNoteCallback(_G["multitap_note_callback_P"..pn])

	for lane,ncr in ipairs(ncr_table) do
		if splSize[lane] then
			-- Allocate spline space and set up the interpretation
			-- (1 point per 192nd note starting at 0, non-beat-subtracting offset)
			splHandle = ncr:GetZoomHandler()
			splHandle:SetSplineMode('NoteColumnSplineMode_Offset')
					 :SetSubtractSongBeat(false)
					 :SetReceptorT(0.0)
					 :SetBeatsPerT(1/48)
			local splObject = splHandle:GetSpline()
			splObject:SetSize(splSize[lane])
			for spli = 1,splSize[lane] do
				splObject:SetPoint(spli, {0, 0, 0})
			end

			-- Set every 192nd note within the multitap region to offset zoom by -1
			-- (i.e., hide the note by zooming it away)
			for mti,mt_desc in ipairs(mt_table) do
				if (mt_desc.lane == lane) and (#mt_desc.taps > 0) then
					for spli=_BB(mt_desc.taps[1]),_BB(mt_desc.taps[#mt_desc.taps]) do
						splObject:SetPoint(spli+1, {-1, -1, -1})
						--Trace("::: "..lane..".("..spli.." of "..splSize[lane]..") or ("..(spli/48)..")")
					end
				end
			end
			-- Calculate and apply spline
			splObject:Solve()
		end
	end
end

local lane_permute = function(pops, l)
	-- Which lane is the desired arrow in?
	-- Account for Left, Right, and Mirror.
	-- Otherwise I honestly don't give heck. You are on your lonesome binch. Tohoku Evolved up in this jawn
	local lanes = {1, 2, 3, 4}

	if pops:Mirror() 	then lanes = {lanes[4], lanes[3], lanes[2], lanes[1]} end
	if pops:Left()		then lanes = {lanes[2], lanes[4], lanes[1], lanes[3]} end
	if pops:Right() 	then lanes = {lanes[3], lanes[1], lanes[4], lanes[2]} end

	return lanes[l]
end
local lane_rotation = {90, 0, 180, 270}					-- Give a tap note actor directions. It lost its GPS and has no concept of "land marks"

local copy_transforms = function(dst, src)
	-- All the
	-- Small things
	-- dst gets
	-- What src brings
	-- Tap, fake, or lift
	-- Transform your shit
	dst:x(src:GetX())
	   :y(src:GetY())
	   :z(src:GetZ())
	   :rotationx(src:GetRotationX())
	   :rotationy(src:GetRotationY())
	   :rotationz(src:GetRotationZ())
--	   :zoom(src:GetZoom())
	   :zoomx(src:GetZoomX())
	   :zoomy(src:GetZoomY())
	   :zoomz(src:GetZoomZ())
end

-- Why is this so inaccessibly hard!!
local GRAY_ARROWS_Y_STANDARD 		= THEME:GetMetric("Player", "ReceptorArrowsYStandard")
local GRAY_ARROWS_Y_REVERSE  		= THEME:GetMetric("Player", "ReceptorArrowsYReverse")
local CENTER_Y_FOR_DILLWEEDS_ONLY	= (GRAY_ARROWS_Y_STANDARD + GRAY_ARROWS_Y_REVERSE) / 2
Trace("### "..CENTER_Y_FOR_DILLWEEDS_ONLY.."x engineers can "..
	  "convert 'thought' into 'piss' in their balls, and issue it in an iterative fashion.")

local __SCALE = function(x, l1, h1, l2, h2)
	return (h2 - l2) * (x - l1) / (h1 - l1) + l2
end

--[[
	See also (in the stepmania source code):

	PlayerNoteFieldPositioner()
	PushPlayerMatrix()
	LoadMenuPerspective(
		fovDegrees=45,
		fWidth=SCREEN_WIDTH,
		fHeight=SCREEN_HEIGHT,
		fVanishPointX=SCALE(skew, 0.1f, 1.0f, x, SCREEN_CENTER_X),
		fVanishPointY=center_y
	)
]]--

local copy_transforms_player = function(dst, pp, skew, tilt, reverse)
	-- I probably ought to refactor this code a bit to reduce the parameter bus
	-- but we all goin to school today!! get your notebooks and noteskins

	skew = skew or 0.0
	tilt = tilt or 0.0
	reverse = reverse or false

	-- you know we could just have a god damn API call for this
	-- "I don't see a use case" yeah because your FOV is only 45 degrees!! owned
	local fov_in = 45
	local vpx_in = __SCALE(skew, 0.1, 1.0, pp:GetX(), SCREEN_CENTER_X)
	local vpy_in = pp:GetY() + CENTER_Y_FOR_DILLWEEDS_ONLY
	--Trace("### ... "..vpx_in..", "..vpy_in)

	local reverse_mult = (reverse and -1 or 1)
	local tilt_degrees = __SCALE(tilt, -1, 1, 30, -30) * reverse_mult
	local zoom_for_dipsticks_only = 0
	local yoff_for_dumbdumbs_only = 0
	if (tilt > 0) then
		zoom_for_dipsticks_only = __SCALE(tilt, 0, 1, 1, 0.9)
		yoff_for_dumbdumbs_only = __SCALE(tilt, 0, 1, 0, -45) * reverse_mult
	else
		zoom_for_dipsticks_only = __SCALE(tilt, 0, -1, 1, 0.9)
		yoff_for_dumbdumbs_only = __SCALE(tilt, 0, -1, 0, -20) * reverse_mult
	end

	-- "The iniquity of the parents on the children, and the children's 
	-- children, to the third and the fourth generation." -- Exodus 34:7
	dst:GetParent():x(pp:GetX())
				   :y(pp:GetY())
				   :z(pp:GetZ())
	-- FOV here stands for "fuck off, venerated_stepmania_developers"
	   			   :fov(fov_in)
	   			   :vanishpoint(vpx_in, vpy_in)

    nf = pp:GetChild("NoteField")
	dst:x(nf:GetX())
	   :y(nf:GetY() + yoff_for_dumbdumbs_only)
	   :z(nf:GetZ())
	   :rotationx(nf:GetRotationX())
	   :rotationy(nf:GetRotationY())
	   :rotationz(nf:GetRotationZ())
	   :zoomx(nf:GetZoomX() * zoom_for_dipsticks_only)
	   :zoomy(nf:GetZoomY() * zoom_for_dipsticks_only)
	   :zoomz(nf:GetZoomZ() * zoom_for_dipsticks_only)
end

local copy_transforms_arrow = function(dst, arrow_only, ps, lane, beat, pos, apply_extra)
	-- Additional translation and rotation are added.
	-- Additional zoom is multiplied.
	-- It's Only Natural

	-- For when the recipe calls for "one clove of garlic" and
	-- you know that isn't right
	apply_extra = apply_extra and apply_extra or {}

	-- Each arrow in its travels acquires a mystical quantity "YOffset",
	-- which dictates its location along the arrow path and when various
	-- arrow effects are applied.
	local y_off = ArrowEffects.GetYOffset(ps, lane, beat + pos) - ArrowEffects.GetYOffset(ps, lane, beat)

	if arrow_only then
		-- Don't rotate the multitap countdown.
		dst:rotationx(ArrowEffects.GetRotationX(ps, y_off, 0, lane) 		+ (apply_extra["rotationx"] and apply_extra["rotationx"] or 0) + MYSTERIOUS_VERSION_DEPENDENT_RADIAN_POLTERGEIST)	-- ??????
		   :rotationy(ArrowEffects.GetRotationY(ps, y_off, lane) 			+ (apply_extra["rotationy"] and apply_extra["rotationy"] or 0))
		   :rotationz(ArrowEffects.GetRotationZ(ps, beat+pos, false, lane) 	+ (apply_extra["rotationz"] and apply_extra["rotationz"] or 0))
--		   :glow(color(1, 1, 1, ArrowEffects.GetGlow(ps, lane, y_off)))		-- TODO: Seems to be always 1? that's weird. I'll fix this when it's actually important
	else
		dst:x(ArrowEffects.GetXPos(ps, lane, y_off)			+ (apply_extra["x"] and apply_extra["x"] or 0))
		   :y(ArrowEffects.GetYPos(ps, lane, y_off) 		+ (apply_extra["y"] and apply_extra["y"] or 0))
		   :z(ArrowEffects.GetZPos(ps, lane, y_off)		    + (apply_extra["z"] and apply_extra["z"] or 0))
		   :zoomx(ArrowEffects.GetZoom(ps, y_off, lane) 	* (apply_extra["zoomx"] and apply_extra["zoomx"] or 1))
		   :zoomy(ArrowEffects.GetZoom(ps, y_off, lane) 	* (apply_extra["zoomy"] and apply_extra["zoomy"] or 1))
		   :zoomz(ArrowEffects.GetZoom(ps, y_off, lane)		* (apply_extra["zoomz"] and apply_extra["zoomz"] or 1))
		   :diffusealpha(ArrowEffects.GetAlpha(ps, lane, y_off))
		   
	end
end


local multitap_update_function = function()
	local status = 1
--	local status, errmsg = pcall( function() -- begin pcall()
		local beat = GAMESTATE:GetSongBeat()
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))

			local ps 	= GAMESTATE:GetPlayerState('PlayerNumber_P'..pn)
			local pp 	= GetPlayerAF(pn)
			local pops 	= ps:GetPlayerOptions("ModsLevel_Song")

			-- This is a convenient enough spot to do just-in-time one-time initialization lol
			if not multitap_splines_calc[pn] then
				-- Select the multitap list that matches the current chart slot.
				full_chart_name = GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty()
				multitap_chart_sel[pn] = string.sub(full_chart_name, 12)
				
				-- Calculate vanishing splines for real taps in multitap regions.
				calc_zoom_splines(multitaps[multitap_chart_sel[pn]], pn)
				multitap_splines_calc[pn] = true
			end

			-- --------------------------------------------------------------------------------
			-- only continue with update function if this stepchart has multitap data  -quietly
			if multitaps[multitap_chart_sel[pn]] then

				-- Adjust the multitap fields with the same transforms the players themselves get.
				-- See Player::PlayerNoteFieldPositioner::PlayerNoteFieldPositioner().
				copy_transforms_player(
					multitap_fields[pn],
					pp,
					pops:Skew(),
					pops:Tilt(),
					pops:GetReversePercentForColumn(0) > 0.5		-- ...sure, whatecer
				)

				-- Read the texture coordinate shift that changes quantization in the noteskin.
				-- Some noteskins are implemented as vertical shifts and some horizontal.
				local tex_color_interval = {
					x = NOTESKIN:GetMetricFForNoteSkin("", "TapNoteNoteColorTextureCoordSpacingX", noteskin_names[pn]),
					y = NOTESKIN:GetMetricFForNoteSkin("", "TapNoteNoteColorTextureCoordSpacingY", noteskin_names[pn]),
				}
				local tex_color_is_rhythm = NOTESKIN:GetMetricBForNoteSkin("", "TapNoteAnimationIsVivid", noteskin_names[pn])
				if multitap_chart_sel[pn] then
					local show_false_explosion = {false, false, false, false}

					for mti,mt_desc in ipairs(multitaps[multitap_chart_sel[pn]]) do
						-- I just wanna know how to present a multitap at this time.
						-- Let someone else do the calculations
						mt_stats = calc_multitap_phase(mt_desc, beat)

						local lperm = lane_permute(pops, mt_desc.lane)		-- Where does this arrow actually land?

						if mt_stats.vis then
							--Trace("??? "..pp:GetChild("NoteField"):GetY())
							--Trace("!!! reproach "..pn..", "..mti.." @ "..beat.." + "..mt_stats.pos.." -> "..y_off.." ("..pos_x..", "..pos_y..", "..pos_z..")")

							-- Show the multitap.
							--		Turn the arrow actor to the right lane direction
							--		Dim the arrow to make the countdown stand out initially
							--		Set the arrow color to the right quantization
							multitap_actors[pn][mti]["frame"]:visible(true)
							multitap_actors[pn][mti]["arrow"]:baserotationz(lane_rotation[lperm])
															 :diffuse(lerp_color(mt_stats.dif, color("#666666"), color("#ffffff")))
															 :texturetranslate(
								tex_color_interval["x"] * qtzn_tex[mt_stats.qtc],
								tex_color_interval["y"] * qtzn_tex[mt_stats.qtc]
								)

							-- To make the multitap convincing, spoof the transformation matrices
							-- and color modifiers from the same calculations as a real tap note.
							copy_transforms_arrow(
								multitap_actors[pn][mti]["frame"], false,
								ps,
								lperm,
								beat,
								mt_stats.pos,
								{zoomx = 1 + mt_stats.sqh}
							)
							copy_transforms_arrow(
								multitap_actors[pn][mti]["arrow"], true,
								ps,
								lperm,
								beat,
								mt_stats.pos,
								{}
							)

							-- Be prepared to fire a fake explosion if any multitap in this lane is active.
							show_false_explosion[lperm] = true

						-- Be prepared to fire a fake explosion if any multitap in this lane is active.
						show_false_explosion[lperm] = true
                        if mt_stats.rem == 6 then
							num = 5
                            multitap_actors[pn][mti]["clock"]:setstate(0):animate(true):visible(true)
						end
                        if mt_stats.rem == 5 then
                            multitap_actors[pn][mti]["shiver"]:zoom(0.14)
							num = 4
						end
						if mt_stats.rem == 4 then
							num = 3
                            multitap_actors[pn][mti]["shiver"]:zoom(0.15)

						end
                        if mt_stats.rem == 3 then
							num = 2
                            multitap_actors[pn][mti]["shiver"]:zoom(0.16)

						end
						if mt_stats.rem == 2 then
							num = 1
                            multitap_actors[pn][mti]["shiver"]:zoom(0.17)

						end
						if mt_stats.rem == 1 then
							num = 0
                            if (not apple[pn]) then
                                multitap_actors[pn][mti]["frame"]:decelerate(0.3):addrotationz(720):zoom(0.1)
                                multitap_actors[pn][mti]["shiver"]:zoom(0.18)
                            end
                            apple[pn] = true

                        else
                            apple[pn] = false
                        end


                        if mt_stats.rem == 0 then
                            SM("0")
                            
                        end

						multitap_actors[pn][mti]["shiver"]:setstate(num)
                        multitap_actors[pn][mti]["frame"]:wag():effectclock("beat")
						if mt_stats.rem >= 1 then
							-- Show the countdown until this multitap degrades into a regular tap
							-- (i.e., 1 hit left)

								-- Use color tables to coordinate with the noteskin and quantization.
								local noteskin_name = noteskin_names[pn]
								local color_pair = qtzn_color_tables["vivid"][1]
								if qtzn_color_tables[noteskin_name] and not tex_color_is_rhythm then
									color_pair = qtzn_color_tables[noteskin_name][qtzn_tex[mt_stats.qtn]+1]
								end

                        -- Set the text actor up with the right number, and a pulsating
                        -- color effect similar to what you'd see on most tap notes.
                        multitap_actors[pn][mti]["count"]:visible(false)
                                        :settext(mt_stats.rem)
                                        :zoom(0.5)
                                        :diffuseramp()
                                        :effectclock("beat")
                                        :effectcolor1(color("#f6d7b0"))
                                        :effectcolor2(color("#e1bf92"))
                            else
                                multitap_actors[pn][mti]["clock"]:visible(false)
                                multitap_actors[pn][mti]["count"]:visible(false)
                            end
						else
							multitap_actors[pn][mti]["frame"]:visible(false)
						end

					end


					for lane=1,4 do
						local lperm = lane_permute(pops, lane)		-- Where does this arrow actually land?

						-- Show the spoofed explosion if we need it, and make sure it's
						-- in the right spot.
						local ex_pos_x = ArrowEffects.GetXPos(ps, lperm, 0)
						local ex_pos_y = ArrowEffects.GetYPos(ps, lperm, 0)
						local ex_pos_z = ArrowEffects.GetZPos(ps, lperm, 0)

						-- TODO: I guess I could incorporate individual column zoom
						-- into this too, but no default mods affect that.
						multitap_explosions[pn][lperm]:xy(ex_pos_x, ex_pos_y)
													  :z(ex_pos_z)
													  :baserotationz(lane_rotation[lperm])
													  :visible(show_false_explosion[lperm])
					end
				end
			end
		end

		TEST_last_beat = beat
--	end -- end pcall()
--	)
	if status then
		--Trace('### YAY TELP DID NOT MAKE A FUCKY WUCKY')
	else
		if not multitap_error then
			Trace('### OOPS TELP HAS MADE A FUCKO BOINGO (in update function)')
			Trace('### '..errmsg)
			Trace('### '..debug.traceback())
		end
	end
end


direction_names = {"Left", "Down", "Up", "Right"}
for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
	local pn = tonumber(string.match(pe, "[0-9]+"))

	local pops = GAMESTATE:GetPlayerState(pe):GetPlayerOptions("ModsLevel_Song")
	local noteskin_name = string.lower(pops:NoteSkin())
	noteskin_names[pn] = noteskin_name
	local frames = {
			{ Frame=0,	Delay=141/60/3.5},
			{ Frame=1,	Delay=141/60/3},
			{ Frame=2,	Delay=141/60/2},
			{ Frame=3,	Delay=141/60/3.5},
            { Frame=4,	Delay=141/60/3.5},
            { Frame=5,	Delay=141/60/2},

	}
	local num = 1
	-- Build out the bags of holding for all the multitap-related actors
	-- (explosions per lane, frames that hold arrows and countdowns)
	local multitap_prep = Def.ActorFrame {
		Name="MultitapFrameP"..pn,
		InitCommand = function(self)
		end,
		OnCommand = function(self)
			multitap_fields[pn] = self
		end,
	}

	for lane=1,4 do
		-- All noteskins should have a suitable actor that accommodates
		-- explosions of all grades.
		-- If this assumption fails, I wanna know about it :P
		multitap_prep[#multitap_prep+1] = NOTESKIN:LoadActorForNoteSkin("Down", "Explosion", noteskin_name)..{
			Name="MultitapExplosionP"..pn.."_"..lane,
			InitCommand=function(self)
			end,
			OnCommand=function(self)
				multitap_explosions[pn][lane] = self
				self:visible(true)
				--Trace("=== Added multitap actor explosion for P"..pn..", lane "..lane)
			end,
		}
	end
	
	for mti = 1,multitap_max do
		-- Each multitap is an ActorFrame with two elements:
		-- 		A tap note loaded from the ative noteskin
		--		A text actor to show the remaining tap count
		multitap_prep[#multitap_prep+1] = Def.ActorFrame {
			Name="MultitapP"..pn.."_"..mti,
			InitCommand=function(self)
			end,
			OnCommand=function(self)
				local i = mti

				multitap_actors[pn][i]["frame"] = self
				self:visible(false)

				--Trace("=== Added multitap actor frame for P"..pn..", index "..i)
			end,

			NOTESKIN:LoadActorForNoteSkin("Down", "Tap Note", noteskin_name)..{
				Name="MultitapArrowP"..pn.."_"..mti,
				InitCommand=function(self)
				end,
				OnCommand=function(self)
					local i = mti

					multitap_actors[pn][i]["arrow"] = self
					self:visible(false)
					--Trace("=== Added multitap actor arrow for P"..pn..", index "..i)
				end,
			},
			Def.Sprite {
				Texture="sand 3x2.png",
				OnCommand= function(self)
					multitap_actors[pn][mti]["shiver"] = self
					self:visible(true):animate(false):zoom(0.13)
					self:SetStateProperties( frames):setstate(5)
				end,
	
			},
            Def.Sprite {
				Texture="clock 10x12.png",
				OnCommand= function(self)
					multitap_actors[pn][mti]["clock"] = self
					self:visible(true):animate(false):zoom(0.19)
					self:addy(2):SetAllStateDelays(0.02):setstate(119):animate(false):diffusealpha(0.8)
				end,
	
			},
            Def.BitmapText {
                -- You can switch the font out, but I recommend:
                -- *  36-48px (42px is ideal; keep in mind arrows are 64px)
                -- *  Generate it with 10px+ padding and add a nice bold
                --    border in post, at least 4px, to distinguish it well
                --    from the underlying arrow
                Name="MultitapTextP"..pn.."_"..mti,
                Font="_komika axis 42px.ini",
                Text="",
                InitCommand=function(self)
                end,
                OnCommand=function(self)
                  local i = mti
        
                  multitap_actors[pn][i]["count"] = self
                  self:visible(false)
                    :z(10.0)            -- Ensure depth z-testing
                                    -- (even though SM5 defaults to init order because That`s Great!)
                    :strokecolor(color("#000000"))
                  --Trace("=== Added multitap actor count for P"..pn..", index "..i)
                end,
              },
		}
	end

	-- The multitap bags of holding need one level of parent to handle 
	-- FOV and positioning in the most accurate way.
	-- I probably could have used a wrapper state here...
	multitap_parent[#multitap_parent+1] = Def.ActorFrame{multitap_prep}
end

multitap_parent[#multitap_parent+1] = Def.ActorFrame {
	Name="Update",
	InitCommand=function(self)	
		Trace("### im alive")
		-- Do all of the it
		self:SetUpdateFunction(multitap_update_function)
	end,

	Def.ActorFrame {
		InitCommand = function(self)
			self:sleep(69420)
		end
	},
    Def.Quad{ InitCommand=function(self) ups_bobheight = self end, OnCommand=cmd(visible,false),
    },
    Def.Quad{ InitCommand=function(self) ups_radius = self end, OnCommand=cmd(visible,false),
    SandSportOnMessageCommand=cmd(linear,2;x,20),
    SandSportOffMessageCommand=cmd(linear,2;x,0),
    },
    Def.ActorFrame{ OnCommand=cmd(y,SCREEN_BOTTOM+150;diffusealpha,0.85),
    SandSportOnMessageCommand=cmd(linear,2;addy,-300;bob;effectmagnitude,0,80,0;effectperiod,8;effectclock,"bgm"),
    SandSportOn2MessageCommand=cmd(linear,2;addy,-380;bob;effectmagnitude,0,160,0;effectperiod,8;effectclock,"bgm"),
    SandSportOn3MessageCommand=cmd(linear,2;addy,-420;bob;effectmagnitude,0,-280,0;effectperiod,8;effectclock,"bgm";diffusealpha,0.7),
    SandSportOffMessageCommand=cmd(decelerate,4;y,SCREEN_BOTTOM+100),
    SandSportOff2MessageCommand=cmd(decelerate,4;y,SCREEN_BOTTOM+180),
    SandSportAwayMessageCommand=cmd(linear,1;y,SCREEN_BOTTOM+420;bob;effectmagnitude,0,0,0;linear,1;y,SCREEN_BOTTOM+150),
    SandSportAway2MessageCommand=cmd(linear,1;y,SCREEN_BOTTOM+220;bob;effectmagnitude,0,0,0;linear,1;y,SCREEN_BOTTOM+150),

        LoadActor("sandtop.png")..{ OnCommand=cmd(vertalign,bottom;x,SCREEN_CENTER_X;y,1;
        customtexturerect,0,0,4,1;zoomx,4;texcoordvelocity,1,0;cropbottom,0.001;croptop,0.001)},
        LoadActor("sand.png")..{ OnCommand=cmd(vertalign,top;x,SCREEN_CENTER_X;y,0;
        customtexturerect,0,0,4,4;zoom,4;texcoordvelocity,1,0;croptop,0.0005)},
    },
}
-- For loop to create 25 flowers and add them to the table
for i = 1, 50 do
    local reverse = math.random(0,60) % 2 == 0
    multitap_parent[#multitap_parent+1] = LoadActor("flower"..math.random(1,6)..".png") .. {
        InitCommand = function(self)
            if (reverse) then
                self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
            else
                self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
            end
            self:zoom(math.random()*(0.20-0.05)+0.05):diffusealpha(0.80)
        end,
        FlowersMessageCommand=function(self)
            -- Spin across the screen
            if (i < 25) then
                self:linear(5*(math.random()+0.5)):addrotationz(720 * (reverse and -1 or 1)):x((reverse and -1 or 5)*SCREEN_WIDTH/4)
                self:queuecommand("Reset")
            end
        end,
        Flowers2MessageCommand=function(self)
            -- Spin across the screen
				self:zoom(math.random()*(0.20-0.03)+0.03)
				self:linear(math.random(3,6)):addrotationz(720 * (reverse and -1 or 1)):x((reverse and -1 or 5)*SCREEN_WIDTH/4)
				self:queuecommand("Reset2")
        end,
        Flowers3MessageCommand=function(self)
            -- Spin across the screen
				self:linear(math.random(2,5)):addrotationz(720 * (reverse and -1 or 1)):y((reverse and -1 or 5)*SCREEN_HEIGHT/4)
				self:queuecommand("Reset2")
        end,
        Reset2Command=function(self)
            if (reverse) then
                self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
            else
                self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
            end
            if (GAMESTATE:GetSongBeat() < 380) then
                if (GAMESTATE:GetSongBeat() >= 350) then
                    if (math.random(0,40) % 2 == 0) then
                        if (reverse) then
                            self:xy(math.random(1,22)*SCREEN_WIDTH/20, 5*SCREEN_HEIGHT/4)
                        else
                            self:xy(math.random(1,22)*SCREEN_WIDTH/20, -1*SCREEN_HEIGHT/4)
                        end
						self:zoom(math.random()*(0.15-0.03)+0.03):diffusealpha(0.90)
                        self:sleep(math.random()):queuecommand("Flowers3")
                    else    
						self:zoom(math.random()*(0.20-0.03)+0.03):diffusealpha(0.90)
                        self:sleep(math.random(0,10)):queuecommand("Flowers2")
                    end
                else
					self:zoom(math.random()*(0.20-0.03)+0.03):diffusealpha(0.90)
                    self:sleep(math.random(0,20)):queuecommand("Flowers2")
                end
            end
        end,
        ResetCommand=function(self)
            if (reverse) then
                self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
            else
                self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
            end
            self:zoom(math.random()*(0.20-0.03)+0.03):diffusealpha(0.90)
        end
    }
end

local reverse = math.random(0,60) % 2 == 0
multitap_parent[#multitap_parent+1] = LoadActor("flower7.png") .. {
	InitCommand = function(self)
		if (reverse) then
			self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
		else
			self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
		end
		self:zoom(math.random()*(0.7-0.1)+0.1):diffusealpha(0.80)
	end,
	FlowersMessageCommand=function(self)
		-- Spin across the screen
			self:linear(5*(math.random()+0.5)):addrotationz(720 * (reverse and -1 or 1)):x((reverse and -1 or 5)*SCREEN_WIDTH/4)
			self:queuecommand("Reset")
	end,
	Flowers2MessageCommand=function(self)
		-- Spin across the screen
		self:zoom(math.random()*(0.7-0.1)+0.1)
		self:linear(math.random(3,6)):addrotationz(720 * (reverse and -1 or 1)):x((reverse and -1 or 5)*SCREEN_WIDTH/4)
		self:queuecommand("Reset2")
	end,
	Flowers3MessageCommand=function(self)
		-- Spin across the screen
		self:linear(math.random(2,5)):addrotationz(720 * (reverse and -1 or 1)):y((reverse and -1 or 5)*SCREEN_HEIGHT/4)
		self:queuecommand("Reset2")
	end,
	Reset2Command=function(self)
		if (reverse) then
			self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
		else
			self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
		end
		self:zoom(math.random()*(0.7-0.1)+0.1):diffusealpha(0.90)
		if (GAMESTATE:GetSongBeat() < 380) then
			if (GAMESTATE:GetSongBeat() >= 350) then
				if (math.random(0,40) % 2 == 0) then
					if (reverse) then
						self:xy(math.random(1,22)*SCREEN_WIDTH/20, 5*SCREEN_HEIGHT/4)
					else
						self:xy(math.random(1,22)*SCREEN_WIDTH/20, -1*SCREEN_HEIGHT/4)
					end
					self:sleep(math.random()):queuecommand("Flowers3")
				else    
					self:sleep(math.random(0,10)):queuecommand("Flowers2")
				end
			else
				self:sleep(math.random(0,20)):queuecommand("Flowers2")
			end
		end
	end,
	RosesMessageCommand=function(self)
		-- Spin across the screen
			self:linear(5*(math.random()+0.5)):addrotationz(720 * (reverse and -1 or 1)):x((reverse and -1 or 5)*SCREEN_WIDTH/4)
			self:queuecommand("Reset")
	end,
	ResetCommand=function(self)
		if (reverse) then
			self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
		else
			self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
		end
		self:zoom(math.random()*(0.7-0.1)+0.1):diffusealpha(0.90)
	end,
	
}


for i = 1, 30 do
	local reverse = math.random(0,60) % 2 == 0
	multitap_parent[#multitap_parent+1] = LoadActor("flower7.png") .. {
		InitCommand = function(self)
			if (reverse) then
				self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
			else
				self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
			end
			self:zoom(math.random()*(0.7-0.1)+0.1):diffusealpha(0.80)
		end,
		RosesMessageCommand=function(self)
			-- Spin across the screen
				self:linear(5*(math.random()+0.5)):addrotationz(720 * (reverse and -1 or 1)):x((reverse and -1 or 5)*SCREEN_WIDTH/4)
				self:queuecommand("Reset")
		end,
		ResetCommand=function(self)
			if (reverse) then
				self:xy(5*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
			else
				self:xy(-1*SCREEN_WIDTH/4, math.random(1,22)*SCREEN_HEIGHT/20)
			end
			self:zoom(math.random()*(0.7-0.1)+0.1):diffusealpha(0.90):sleep(0.3):visible(false)
		end
	}
end

-- Done!
return multitap_parent
